#include "KTH57XXJoystick.h"
#include <math.h>

float magXmax, magXmin, magYmax, magYmin; //XᡢYУ׼Χ
float magXcen, magYcen;//XᡢYĵ
float magXranP, magXranN, magYranP, magYranN;
float magXzeroP, magXzeroN, magYzeroP, magYzeroN;

float KTH57XXGetAmount(int tempX, int tempY, int tempZ)
{
	// sqrt(x^2 + y^2 + z^2)
	return sqrt(pow(tempX, 2) + pow(tempY, 2) + pow(tempZ, 2));
}


float KTH57XXGetAzimuth(int tempX, int tempY)
{
	// arctan(y/x)
	return atan2(tempY, tempX);
}


float KTH57XXGetPolar(int tempX, int tempY, int tempZ)
{
	// arctan(z/(sqrt(x^2+y^2)))
	return atan2(tempZ, sqrt(pow(tempX, 2) + pow(tempY, 2)));
}


//dataIn[0] XYZ
//Xݰ˳ dataIn
void KTH57XXJoYGetRange(unsigned short int dataIn[12])
{
	unsigned char i;
	int magData[12]; //ÿXYZӦз
	float tempSph[12];//ÿϵ˳ǣRAzi, Polar
	float tempMag[8];//ϵõ XYֵ˳
	
	
	//16bit޷תΪз
	for(i= 0; i< 12; i++)
	{
		magData[i] = dataIn[i] - 32768;
	}
	
	//ĸϵ
  for(i= 0; i< 4; i++)
	{
		tempSph[i*3] = KTH57XXGetAmount(magData[i*3], magData[i*3+1], magData[i*3+2]);
		tempSph[i*3+1] = KTH57XXGetAzimuth(magData[i*3], magData[i*3+1]);
		tempSph[i*3+2] = KTH57XXGetPolar(magData[i*3], magData[i*3+1], magData[i*3+2]);
	}
	
	//ٸĸϵõĸӦXY
	for(i= 0; i< 4; i++)
	{
		tempMag[i*2] = tempSph[i*3]*cos(tempSph[i*3+2])*cos(tempSph[i*3+1]);
		tempMag[i*2+1] = tempSph[i*3]*cos(tempSph[i*3+2])*sin(tempSph[i*3+1]);		
	}
	
	//жĸֱXУ׼YУ׼
	for(i= 0; i< 4; i++)
	{
		if(fabs(tempMag[i*2]) > fabs(tempMag[i*2+1])) //XֵYֵ˵ʱĴųǿXǿôֵӦXУ׼
		{
			if( tempMag[i*2]> 0 )   //Xֵ0˵XУ׼ֵXֵС0˵XḺУ׼ֵ
				magXmax = tempMag[i*2];
			else
				magXmin = tempMag[i*2];
		}
		else
		{
			if( tempMag[i*2+1]> 0) //Yֵ0,˵YУ׼
				magYmax = tempMag[i*2+1];
			else
        magYmin = tempMag[i*2+1];			
		}
	}
	
}

//ĵXYZ˳дdataIn
void KTH57XXJoYGetCenter(unsigned short int dataIn[3])
{
	unsigned char i;
	int magData[3]; //ÿXYZӦз
	float tempSph[3];//ĵϵ˳ǣRAzi, Polar
	
	//16bit޷תΪз
	for(i= 0; i< 3; i++)
	{
		magData[i] = dataIn[i] - 32768;
	}
	
	//ĵϵ
	tempSph[0] = KTH57XXGetAmount(magData[0], magData[1], magData[2]);
	tempSph[1] = KTH57XXGetAzimuth(magData[0], magData[1]);
	tempSph[2] = KTH57XXGetPolar(magData[0], magData[1], magData[2]);
	
	magXcen = tempSph[0]*cos(tempSph[2])*cos(tempSph[1]);
	magYcen = tempSph[0]*cos(tempSph[2])*sin(tempSph[1]);		

}

void KTH57XXJoyRange(float zeroR)
{
	
	 magXzeroP = magXcen + (magXmax - magXcen)*zeroR;
   magXzeroN = magXcen - (magXcen - magXmin)*zeroR;
	 magYzeroP = magYcen + (magYmax - magYcen)*zeroR;
   magYzeroN = magYcen - (magYcen - magYmin)*zeroR;
	
	
	 magXranP = magXmax - magXzeroP;
	 magXranN = magXzeroN - magXmin;
   magYranP = magYmax - magYzeroP;
	 magYranN = magYzeroN - magYmin;
	
}

//õXYУ׼ΧǶ
//OutLData[12]:ĸ
//CenData[3]:ĵ
//zeroRĵռ̵İٷֱ
void KTH57XXJoyInitial(unsigned short int OutLData[12],unsigned short int CenData[3],float zeroR)
{
	KTH57XXJoYGetRange(OutLData);
	KTH57XXJoYGetCenter(CenData);
	KTH57XXJoyRange(zeroR);
}


//ųֵ ˳ΪXYZ
// ˳ΪdataOut[0]:x dataOut[1]:y
//OutRange ÿӦ
void KTH57XXJoyUni(unsigned short int magDataIn[3], float dataOut[2], unsigned short int OutRange)
{
  float tempX, tempY, sphData[3];
	int tempMag[3];//޷תΪз
	unsigned char i;
	
	for(i= 0; i< 3; i++)
	{
		tempMag[i]  = magDataIn[i] -32768;
	}
	
	sphData[0] = KTH57XXGetAmount(tempMag[0], tempMag[1], tempMag[2]);
	sphData[1] = KTH57XXGetAzimuth(tempMag[0], tempMag[1]);
	sphData[2] = KTH57XXGetPolar(tempMag[0], tempMag[1], tempMag[2]);
	
  tempX = sphData[0]*cos(sphData[2])*cos(sphData[1]);
	tempY = sphData[0]*cos(sphData[2])*sin(sphData[1]);

	if(tempX > magXzeroP)
	{
		dataOut[0] = ( tempX - magXzeroP )/ magXranP * OutRange;
	}
	else if(tempX < magXzeroN)
	{
		dataOut[0] = ( tempX - magXzeroN )/ magXranN * OutRange;
	}
	else
	{
		dataOut[0] = 0;
	}
	
	if(tempY > magYzeroP)
	{
		dataOut[1] = ( tempY - magYzeroP )/ magYranP * OutRange;
	}
	else if(tempY < magYzeroN)
	{
		dataOut[1] = ( tempY - magYzeroN )/ magYranN * OutRange;
	}
	else
	{
		dataOut[1] = 0;
	}	
	
}

