#include "IIC.h"

uint8_t IIC_ADDR = 0; //I2Cַ

void usleep(uint16_t t)
{
	for(uint16_t i=0;i<16*t;i++)
	{
		__NOP();
	}
}

/**
  * @brief  SDAͨŵGPIOڸΪ״̬
  * @param  
  * @retval  
  */
void IIC_In(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;
	__HAL_RCC_GPIOB_CLK_ENABLE();    //SDAͨſʱ
	GPIO_InitStruct.Pin = SDA_Pin;
	GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
	GPIO_InitStruct.Pull = GPIO_PULLUP;
	HAL_GPIO_Init(SDA_GPIO_Port, &GPIO_InitStruct);
}

/**
  * @brief  SDAͨŵGPIOڸΪ״̬
  * @param  
  * @retval  
  */
void IIC_Out(void)
{
	GPIO_InitTypeDef GPIO_InitStruct;
	__HAL_RCC_GPIOB_CLK_ENABLE();
	GPIO_InitStruct.Pin = SDA_Pin;
	GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
	GPIO_InitStruct.Pull = GPIO_PULLUP;
	GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_HIGH;
	HAL_GPIO_Init(SDA_GPIO_Port, &GPIO_InitStruct);
	usleep(10);
}

/**
  * @brief  IIC startź
  * @param  
  * @retval  
  */
void IIC_Start(void)
{
	sda_setout;
  clk_hight;
	sda_hight;
	usleep(4);
	sda_low;
	usleep(4);
	clk_low;
}

/**
  * @brief  IIC startź
  * @param  
  * @retval  
  */
void IIC_Stop(void)
{
	sda_setout;
	sda_low;
	clk_low;
	usleep(4);
	clk_hight;
	sda_hight; 
	usleep(4);	
}

/**
  * @brief  IIC nackź
  * @param  
  * @retval  
  */
void IIC_Nack(void)
{		
	clk_low;
	sda_setout;
	sda_hight;
	usleep(2);	
	clk_hight;
	usleep(2);
	clk_low;
}

/**
  * @brief  IIC ackź
  * @param  
  * @retval  
  */
void IIC_Ack(void)
{
	clk_low;
	sda_setout;
	sda_low;
	usleep(2);
	clk_hight;
	usleep(2);
	clk_low;
}

/**
  * @brief  IIC wait ack
  * @param  
  * @retval IICǷack 
  */
uint8_t IIC_Wait_Ack(void)
{	
    uint16_t ucErrTime=0;

    sda_setin;
    clk_hight;
    usleep(1);
    while(sda_rd)
    {
				ucErrTime++;
				if(ucErrTime>500)
				{
						IIC_Stop();
						return IIC_ERROR;
				}
    }
    clk_low;
    return IIC_OK;
}


/**
  * @brief  д8λַ
  * @param  8λַ
  * @retval  
  */
void IIC_Write_Byte(uint8_t byte)
{
	
	uint8_t i; 
	
	sda_setout;	    
	clk_low;
	for(i=0;i<8;i++)
	{
		if((byte & 0x80)>>7)
			sda_hight;
		else
			sda_low;
		byte <<= 1;
		usleep(2);
		clk_hight;
		usleep(2);
		clk_low;
		usleep(2);
	}
		
}

/**
  * @brief  ȡ8λ
  * @param  ǷҪackź 
  * @retval ȡ8λ
  */
uint8_t IIC_Read_Byte(unsigned char ack)
{
	
	uint8_t i;
  uint8_t temp;
	
	temp = 0;
	
	sda_setin;
	for(i=0;i<8;i++ )
	{
		clk_low; 
		usleep(2);
		clk_hight;
		temp<<=1;
		if(sda_rd) temp++;
	  usleep(1);
	}					 
	
	if (!ack)
			IIC_Nack();
	else
			IIC_Ack(); 
	
	return temp;
}



