/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2022 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "usart.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "KTH57XXIIC.h"

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */
/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
uint8_t RegisterData[3]={0};//存放读取寄存器时返回的值 RegisterData[0]：status RegisterData[1]：寄存器高八位 RegisterData[2]：寄存器低八位
uint8_t DataReadFrame[9]={0};//存放测量结束读回的数据

char buf[6];
float angle = 0,calib_angle = 0;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */
	int16_t x, y;
	uint16_t xTemp,yTemp;

	uint8_t get_sample = 0,ang_get_l = 0,ang_get_h = 0;
	uint8_t calib_sample_flag = 0;

	int16_t x_max,x_min,y_max,y_min;
  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_USART2_UART_Init();
  /* USER CODE BEGIN 2 */
	
	/* 第一步：初始化IIC地址和寄存器配置 */
	HAL_Delay(5);
	
  KTH57XXInitial(0,0);
	
	HAL_Delay(5);
	
	/*第二步：开启持续感应模式*/
	
  KTH57XXContinuousSensing(0X0f);
	
  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
	  /*第三步：开启离轴模式*/ 
		if(strcmp(buf,"start")==0)
		{
			
			/*采样点采样*/
			if(calib_sample_flag == 0)
			{
				KTH57XXDataRead(0X0f);
				
				x = ( DataReadFrame[3] << 8) + DataReadFrame[4] - 0x7fff;
				y = ( DataReadFrame[5] << 8) + DataReadFrame[6] - 0x7fff;
				
			
				angle = atan2(y,x)*57.3 + 180;
				
					
				if(get_sample == 0)
				{
					printf("开始离轴校准，请缓慢旋转磁铁。\n");
					x_max = x;
					x_min = x;
					y_max = y;
					y_min = y;
					
					ang_get_l = angle/10;
					ang_get_h = ang_get_l + 1;
					
					get_sample++;
					printf("已采样%d个点\n",get_sample);
				}
				else if(get_sample < 36)
				{
					if (ang_get_l == 0)
						ang_get_l = 36;
					if (ang_get_h == 36)
						ang_get_h = 0;
					
					angle = angle/10;
					if((uint8_t)angle == ang_get_l -1)
					{	
						if(x_max < x)
						{
							x_max = x;
						}
						if(x_min > x)
						{
							x_min = x;			
						}
						
						if(y_max < y)
						{
							y_max = y;
						}
						if(y_min > y)
						{
							y_min = y;			
						}
						ang_get_l--;
						get_sample++;
						printf("已采样%d个点\n",get_sample);
					}
					else if((uint8_t)angle == ang_get_h)
					{
						if(x_max < x)
						{
							x_max = x;
						}
						if(x_min > x)
						{
							x_min = x;			
						}
						
						if(y_max < y)
						{
							y_max = y;
						}
						if(y_min > y)
						{
							y_min = y;			
						}
						ang_get_h++;
						get_sample++;
						printf("已采样%d个点\n",get_sample);
					}
				}
				else if(get_sample == 36)
				{
						x_max = (x_max - x_min)/2;
						y_max = (y_max - y_min)/2;
						
						calib_sample_flag = 1;
						printf("离轴校准结束\n");
				}
			}
			else//离轴校准完成后输出校准前后角度
			{
				KTH57XXDataRead(0X0f);
				x = ( DataReadFrame[3] << 8) + DataReadFrame[4] - 0x7fff;
				y = ( DataReadFrame[5] << 8) + DataReadFrame[6] - 0x7fff;
				
				angle = atan2(y,x)*57.3 + 180;
				calib_angle = atan2((float)y/y_max,(float)x/x_max)*57.3 + 180;
				
				printf("较准前角度:%0.1f，校准后角度:%0.1f \n",angle,calib_angle);
			}
		}
		else
		{
			printf("请发送'start'开始离轴校准 \n");
			scanf("%s",buf);
		}
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.HSICalibrationValue = RCC_HSICALIBRATION_DEFAULT;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_NONE;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }
  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_HSI;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV8;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_0) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */

