#include "KTH57XXSPI.h"


/**
  * @brief  写入8位地址或数据
  * @param  8位地址或数据
  * @retval 无 
  */
void WriteByte(uint8_t byte)
{ 
	uint8_t i;
	
	for(i = 0;i < 8;i++)  
	{
		SCL_Clr();
		
		if(byte & 0x80)
			 MOSI_Set();
		else 
			 MOSI_Clr();
		
		SCL_Set();

		byte <<= 1;  	
	}	
}

/**
  * @brief  读取8位数据
  * @param  无
  * @retval 读取的8位数据
  */
uint8_t ReadByte(void)
{
	uint8_t i;
	uint8_t byte;
	uint8_t temp;
	
	for(i = 0;i < 8;i++)  
	{
		SCL_Clr();

		temp = MISO_Read();
		byte = ( byte << 1 ) + temp;
		
		SCL_Set();

	}	
	return byte;
}



/**
  * @brief  开启持续感应模式
  * @param  axis：ZYXT 设置对哪个测量项进行测量 
  * @retval 芯片工作状态（status）
  */
uint8_t KTH57XXContinuousSensing(uint8_t axis)
{
	uint8_t sta;	
  uint8_t com;
	
	com = CONTINUOUS_SENSING | axis;

	CS_Clr();

	WriteByte(com); 
	sta = ReadByte();		
	
	CS_Set();
	
	return 	sta;  
}

/**
  * @brief  开启唤醒睡眠模式
  * @param  axis：ZYXT 设置对哪个测量项进行测量 
  * @retval 芯片工作状态（status）
  */
uint8_t KTH57XXWakeupSleep(uint8_t axis)
{
	uint8_t sta;	
  uint8_t com;
	
  com = WAKEUP_SLEEP | axis;

	CS_Clr();

	WriteByte(com); 
	sta = ReadByte();	
	
	CS_Set();

	
	return sta;  
}

/**
  * @brief  开启单次测量模式
  * @param  axis：ZYXT 设置对哪个测量项进行测量 
  * @retval 芯片工作状态（status）
  */
uint8_t KTH57XXSingleConversion(uint8_t axis)
{
	uint8_t sta;	
	uint8_t com;

	com= SINGLE_CONVERSION | axis;	

	CS_Clr();

	WriteByte(com); 
	sta = ReadByte();	 

	CS_Set();


	return sta;  
}

/**
  * @brief  开启空闲模式
  * @param  无
  * @retval 芯片工作状态（status）
  */
uint8_t KTH57XXIdle(void)
{
	uint8_t sta = 0;
	uint8_t com;
	
	com = IDLE;

	CS_Clr();
	 
	WriteByte(com);	
	sta = ReadByte();
	
	CS_Set();
	
  return sta;
	
}



/**
  * @brief  芯片重置
  * @param  无
  * @retval 无
  */
void KTH57XXReset(void)
{
  uint8_t com = 0;

  com = RESET;		

	CS_Clr();

	WriteByte(com); 	
	
	CS_Set();

}

/**
  * @brief  读取芯片测量结果 芯片测量结果放在 DataReadFrame 数组中 
  * @param  axis：ZYXT 设置对哪个测量项进行输出 
  * @retval 返回的字节数
  */
uint8_t KTH57XXDataRead(uint8_t axis)
{
	uint8_t i;	
	uint8_t com;
	uint8_t counter=1;//根据axis来计算一共需要读回多少测量数据，存放在counter中
	
	com = DATA_READ | axis;	
	
	for(i=0;i<4;i++)
	{
		counter = counter + ( axis & 0x01 )*2;
		axis = axis >> 1;
	}

	CS_Clr();
	
	WriteByte(com);
	
	for(i = 0;i < counter;i++) 
	{	
		DataReadFrame[i] = ReadByte();
	}
	
	CS_Set();
	
	return counter;
}


/**
  * @brief  读取寄存器数据 
  *         寄存器中的值以及芯片工作状态存放在RegisterData数组中
  * @param  Register：寄存器
  * @retval 无
  */
void KTH57XXReadRegister(uint8_t Register)
{
	uint8_t i;	
	uint8_t registerName;
	uint8_t comRR[2]; 
	
	registerName = Register <<2 ; //读取时寄存器要左移两位
	comRR[0] = READ_REGISTER;
	comRR[1] = registerName; 

	CS_Clr();
	
	for(i=0;i<2;i++)
	{
 		WriteByte(comRR[i]);		
    }
	for(i=0;i<3;i++)
	{
		RegisterData[i]=ReadByte();
	}
	
	CS_Set();
}

/**
  * @brief  向寄存器中写入配置
  * @param  writeData：写入寄存器的数据
  *         Register ：需写入的寄存器
  * @retval 芯片工作状态（status）
  */
uint8_t KTH57XXWriteRegister (uint16_t writeData,uint8_t Register)
{
	uint8_t i;	
	uint8_t registerName;
	uint8_t sta = 0;
	uint8_t comWR[4]; 
	
	registerName = Register <<2 ;
	comWR[0] = WRITE_REGISTER;
	comWR[1] = writeData >> 8; 
	comWR[2] = writeData & 0xff;
	comWR[3] = registerName;
	
	CS_Clr();
	
	for(i = 0;i < 4;i++)
	{
	  WriteByte(comWR[i]);		
    }
	
	sta = ReadByte();
	
	CS_Set();

	return sta;
	
}

void delay(void)
{
	uint8_t i;
	for(i=0;i<5;i++)
	 __NOP();
}

void KTH57XXRegInitial(void) 
{
	
	KTH57XXWriteRegister (0x14B0,28);
  KTH57XXWriteRegister (0x03c2,29);

}


